// create_markers.js
const categoryToIdMap = {
    "Χώροι Στάθμευσης": 1,
    "Διαβάσεις": 2,
    "Ράμπες Πεζοδρομίων": 3,
    "Ράμπες Εισόδου Κτιρίων": 4
};

// Ορισμός αριθμητικών πεδίων ανά κατηγορία
const numericFieldsMap = {
    "Χώροι Στάθμευσης": ['length','width','side_clearance_width','side_clearance_lr'],
    "Διαβάσεις": ['signal_phase_duration'],
    "Ράμπες Πεζοδρομίων": ['length','width','slope'],
    "Ράμπες Εισόδου Κτιρίων": ['length','width','slope','door_width']
};

// Φόρτωση Δημοτικών Ενοτήτων
let dimotikiEnotitaMap = {};

fetch('get_dim_enot_info_window.php')
    .then(r => r.json())
    .then(data => {
        dimotikiEnotitaMap = data;
        console.log('Loaded dimotikiEnotitaMap', dimotikiEnotitaMap);
    })
    .catch(err => console.error('DE map load error', err));

// Άνοιγμα popup για νέο ή υπάρχον marker
function openNewForm(lat, lng, defaultCategory = "Χώροι Στάθμευσης", existingData = null) {
    const container = document.createElement('div');
    container.className = 'popup-form';
    container.style = `
        position: absolute; 
        left: 50%; 
        top: 50%;
        transform: translate(-50%, -50%);
        z-index: 1000;
        background: white;
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 4px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.3);
        min-width: 280px;
    `;

    container.innerHTML = `
        <div id="popupHeader" style="display:flex; justify-content:space-between; align-items:center; margin-bottom:10px; cursor: move;">
            <h4 style="margin:0">Επιλέξτε Οντότητα</h4>
            <button id="closePopup" class="btn btn-danger btn-xs">✖</button>
        </div>
        <select id="entitySelect" class="form-control">
            ${Object.keys(categoryToIdMap).map(cat => `<option value="${cat}">${cat}</option>`).join('')}
        </select>
        <div id="entityFields" style="margin-top:10px;"></div>
    `;


    document.body.appendChild(container);

    const entitySelect = container.querySelector('#entitySelect');
    const entityFields = container.querySelector('#entityFields');
    const initialCategory = existingData ? existingData.category : defaultCategory;
    entitySelect.value = initialCategory;

    // --- Draggable ---
    makeDraggable(container, '#popupHeader');

    // --- Κλείσιμο popup ---
    container.querySelector('#closePopup').addEventListener('click', () => container.remove());

    // --- Εμφάνιση πεδίων ανά κατηγορία ---
    function renderFields(category) {
        entityFields.innerHTML = getTabFieldsHTML(category); // HTML πεδίων για την κατηγορία
        setLatLngFields(entityFields, category, lat, lng);  // Προσθήκη πεδίων lat/lng

        if (existingData) populateFields(entityFields, existingData); // Υπάρχοντα δεδομένα

        attachSaveButton(entityFields, container, category, lat, lng, existingData);

        // --- Dropdown για Δημοτικές Ενότητες ---
        const selectDE = entityFields.querySelector('#dimotiki_enotita_id');
        if (selectDE) {
            fetch('get_dim_enot.php')
                .then(res => res.json())
                .then(data => {
                    selectDE.innerHTML = '<option value="">--Επιλέξτε--</option>';
                    data.forEach(de => {
                        const option = document.createElement('option');
                        option.value = de.id;
                        option.textContent = de.onoma;
                        selectDE.appendChild(option);
                    });
                    // Αν υπάρχει existingData, επιλογή σωστής τιμής
                    if (existingData?.dimotiki_enotita_id) selectDE.value = existingData.dimotiki_enotita_id;
                    
                })
                .catch(err => console.error('Σφάλμα φόρτωσης δημοτικών ενοτήτων:', err));
        }
    }

    renderFields(initialCategory);

    entitySelect.addEventListener('change', () => renderFields(entitySelect.value));
}


// --- Save button με validate & αποστολή στη βάση ---
/**
 * Συνδέει το κουμπί Αποθήκευσης με τα πεδία μιας φόρμας
 * @param {HTMLElement} fieldsDiv - Το container με τα inputs
 * @param {HTMLElement} formContainer - Το container της φόρμας
 * @param {string} category - Κατηγορία marker
 * @param {number} lat - Γεωγραφικό πλάτος
 * @param {number} lng - Γεωγραφικό μήκος
 * @param {Object|null} existingData - Υπάρχοντα δεδομένα marker (αν είναι επεξεργασία)
 */
function attachSaveButton(fieldsDiv, formContainer, category, lat, lng, existingData = null) {
    // Βρίσκουμε ή δημιουργούμε το κουμπί save
    let saveBtn = fieldsDiv.querySelector('#saveMarker');
    if (!saveBtn) {
        saveBtn = document.createElement('button');
        saveBtn.type = 'button';
        saveBtn.id = 'saveMarker';
        saveBtn.className = 'btn btn-primary btn-block';
        saveBtn.style.marginTop = '10px';
        saveBtn.textContent = 'Αποθήκευση';
        fieldsDiv.appendChild(saveBtn);
    }

    saveBtn.addEventListener('click', async () => {
        // Validate
        if (!validateFields(fieldsDiv)) return;

        //  Συλλογή δεδομένων από τα πεδία
        const data = existingData || { lat, lng, category };
        data.category = category;

        [...fieldsDiv.querySelectorAll('input, textarea, select')].forEach(el => {
            let val;
            if (el.type === 'checkbox') val = el.checked;
            else if (el.type === 'file') val = el.files[0]?.name || null;
            else val = el.tagName === 'SELECT' ? (el.value || null) : (el.value || null);

            // Αριθμητικά πεδία
            if (numericFieldsMap[category]?.includes(el.id)) {
                if (val === null || val === '') val = null;
                else val = parseFloat(val);
                if (isNaN(val)) val = null;
            }

            data[el.id] = val;
        });

        //  Προσθήκη category_id
        data.category_id = categoryToIdMap[category] || 0;

        //  Δημιουργία αντικειμένου για τον server (χωρίς το marker)
        const dataToSend = {};
        for (let key in data) {
            if (key === 'marker') continue;
            dataToSend[key] = data[key];
        }

        try {
            //  Αποστολή στον server
            const formData = new FormData();

            // Απλά πεδία
            for (let key in dataToSend) {
                if (dataToSend[key] !== undefined && dataToSend[key] !== null) {
                    formData.append(key, dataToSend[key]);
                }
            }

            // Αρχεία
            fieldsDiv.querySelectorAll('input[type="file"]').forEach(input => {
                if (input.files?.[0]) formData.append(input.id, input.files[0]);
            });


            const res = await fetch('/va/save_markers.php', {
                method: 'POST',
                body: formData
            });

            const result = await res.json();

            if (result.status === "success") {
                data.id = result.id;

                // ΠΟΛΥ ΣΗΜΑΝΤΙΚΟ
                if (result.image1 !== undefined) data.image1 = result.image1;
                if (result.image2 !== undefined) data.image2 = result.image2; // ενημέρωση ID από server

            } else {
                console.error('Αποτυχία αποθήκευσης marker:', result);
                return;
            }

            // Δημιουργία marker αν είναι νέο
            if (!existingData) {
                const marker = new google.maps.Marker({
                    position: { lat, lng },
                    map: map,
                    icon: { url: getMarkerIcon(category), scaledSize: new google.maps.Size(36, 36) }
                });
                data.marker = marker;

                // Σύνδεση InfoWindow
                attachInfoWindow(marker, data);

            } else {
                // Αν υπάρχει marker, ανανέωση InfoWindow περιεχομένου
                if (data.marker) {
                    const iw = new google.maps.InfoWindow({
                        content: generateInfoHTML(data)
                    });
                    attachInfoWindow(data.marker, data);
                }
            }

            //  Κλείσιμο φόρμας
            if (formContainer) formContainer.style.display = 'none';

        } catch (err) {
            console.error('Σφάλμα κατά την αποθήκευση:', err);
        }
    });
}
