<?php
// delete_marker.php

session_start();
header('Content-Type: application/json');
require_once __DIR__ . '/db.php';

// Λήψη δεδομένων JSON από το POST
$data = json_decode(file_get_contents('php://input'), true);

// Mετατροπή σε ακέραιους
$id = isset($data['id']) ? (int)$data['id'] : null;
$category_id = isset($data['category_id']) ? (int)$data['category_id'] : null;

// Έλεγχος απαραίτητων πεδίων
if (!$id || !$category_id) {
    echo json_encode(['success' => false, 'message' => 'Λείπει το id ή η κατηγορία']);
    exit;
}

$tables = [
    1 => 'parking',
    2 => 'crossings',
    3 => 'pedestrian_ramps',
    4 => 'building_ramps'
];

$table = $tables[$category_id] ?? null;

// Έλεγχος έγκυρης κατηγορίας
if (!$table) {
    echo json_encode(['success' => false, 'message' => 'Μη έγκυρη κατηγορία']);
    exit;
}

try {
    // Διαγραφή εγγραφής από τον κατάλληλο πίνακα
    $stmt = $pdo->prepare("DELETE FROM {$table} WHERE id = :id");
    $stmt->execute(['id' => $id]);

    echo json_encode(['success' => true]);
} catch (PDOException $e) {
    // Σφάλμα βάσης δεδομένων
    echo json_encode([
        'success' => false,
        'message' => 'Σφάλμα βάσης'
    ]);
}
