//fields.js
// Η συνάρτηση που επιστρέφει HTML των πεδίων
function getTabFieldsHTML(category){

  if(category==="Χώροι Στάθμευσης"){
    return `
    
      <div id="1" style="margin-top:5px; font-size:smaller; color:#555;">
        <span style="color:red">*</span> Υποχρεωτικά πεδία
      </div>
      <br>

      <div class="inline-fields">
        <div class="field large">
          <label for="odos" class="required">Οδός:</label>
          <input class="form-control" id="odos" type="text" required>
        </div>
        <div class="field large">
          <label for="arithmos" class="required">Αριθμός:</label>
          <input class="form-control" id="arithmos" type="text" required>
        </div>
      </div>

      <div class="field large">
        <label for="dimotiki_enotita_id">Δημοτική Ενότητα: </label>
        <select class="form-control" id="dimotiki_enotita_id">
          <option value="">--Επιλέξτε--</option>
          <!-- Οι επιλογές θα γεμίσουν δυναμικά -->
        </select>
      </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="status" class="required">Ιδιοκτησιακό καθεστώς:</label>
          <select class="form-control" id="status" required>
            <option value="">--Επιλέξτε--</option>
            <option value="1">Δημόσιο</option>
            <option value="2">Ιδιωτικό</option>             
          </select>
        </div>

        <div class="field large">
          <label for="vehicle_type" class="required">Τύπος Οχήματος:</label>
          <select class="form-control" id="vehicle_type" required>
            <option value="">--Επιλέξτε--</option>
            <option value="1">Συμβατικό</option>
            <option value="2">Ηλεκτρικό</option>             
          </select>
        </div>

        <div class="field large">
          <label for="car_plate" class="required">Πινακίδα Οχήματος:</label>
          <input class="form-control" 
                type="text" 
                id="car_plate" 
                maxlength="7" 
                pattern="[A-Za-z]{3}[0-9]{4}" 
                title="3 γράμματα ακολουθούμενα από 4 αριθμούς, π.χ. ABC1234" 
                placeholder="π.χ. ABC1234" 
                required>
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="length">Μήκος χώρου στάθμευσης(m):</label>
          <input class="form-control" type="number" id="length" step="0.01" >
        </div>
        <div class="field large">
          <label for="width">Πλάτος χώρου στάθμευσης(m):</label>
          <input class="form-control" type="number" id="width" step="0.01">
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="side_clearance_width">Πλάτος βοηθητικής ζώνης (m):</label>
          <input class="form-control" type="number" id="side_clearance_width" step="0.01" placeholder="π.χ. 1.20">
        </div>
        <div class="field large">
          <label for="side_clearance_lr">Πλευρική ζώνη αριστερά/δεξιά:</label>
          <select class="form-control" id="side_clearance_lr">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Αριστερά</option>
            <option value="2">Δεξιά</option>
            <option value="3">Και τα δύο</option>
          </select>
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="ramp_nearby">Υπάρχει ράμπα κοντά:</label>
          <select class="form-control" id="ramp_nearby">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>
        <div class="field large">
          <label for="accessible_route">Προσβάσιμη διαδρομή προς πεζοδρόμιο:</label>
          <select class="form-control" id="accessible_route">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="simansi_stylou">Σήμανση στο πεζοδρόμιο:</label>
          <select class="form-control" id="simansi_stylou">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>  
        </div>
        <div class="field large">
          <label for="road_marking">Σήμανση στο οδόστρωμα:</label>
          <select class="form-control" id="road_marking">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="lighting">Φωτισμός:</label>
          <select class="form-control" id="lighting">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>
        <div class="field large">
          <label for="roof">Στέγαση:</label>
          <select class="form-control" id="roof">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="image1">Φωτογραφία 1:</label>
          <input class="form-control" id="image1" name="image1" type="file">
        </div>
        <div class="field large">
          <label for="image2">Φωτογραφία 2:</label>
          <input class="form-control" id="image2" name="image2" type="file">
        </div>
      </div>

      <label for="street_view">Street View URL:</label>
      <input class="form-control" type="url" id="street_view">

      <label for="comments">Σχόλια:</label>
      <textarea class="form-control" id="comments" rows="3" placeholder="Προσθέστε τυχόν παρατηρήσεις…"></textarea>

      <div class="inline-fields">
        <div class="field large">
            <label for="parking_latitude">Latitude:</label>
            <input class="form-control" type="text" id="parking_latitude" readonly>
        </div>
        <div class="field large">
            <label for="parking_longitude">Longitude:</label>
            <input class="form-control" type="text" id="parking_longitude" readonly>
        </div>
      </div>

    `;

        
    } else if(category==="Διαβάσεις"){
    return `
      
      <div id="2" style="margin-top:5px; font-size:smaller; color:#555;">
        <span style="color:red">*</span> Υποχρεωτικά πεδία
      </div>
      <br>

      <div class="inline-fields">
        <div class="field large">
          <label for="odos1" class="required">Οδός 1:</label>
          <input class="form-control" id="odos1" type="text" title="Οδός 1ης Διάβασης" required>
        </div>
        <div class="field large">
          <label for="arithmos1" class="required">Αριθμός 1:</label>
          <input class="form-control" id="arithmos1" type="text" required>
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="odos2">Οδός 2:</label>
          <input class="form-control" id="odos2" type="text" title="Οδός 2ης Διάβασης">
        </div>
        <div class="field large">
          <label for="arithmos2">Αριθμός 2:</label>
          <input class="form-control" id="arithmos2" type="text">
        </div>
      </div>

      <div class="inline-fields">
        
      <div class="field large">
        <label for="dimotiki_enotita_id">Δημοτική Ενότητα: </label>
        <select class="form-control" id="dimotiki_enotita_id">
          <option value="">--Επιλέξτε--</option>
          <!-- Οι επιλογές θα γεμίσουν δυναμικά -->
        </select>
      </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="typos_odou">Τύπος Οδού:</label>
          <select class="form-control" id="typos_odou">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Τοπικός δρόμος / χαμηλής κυκλοφορίας</option>
            <option value="2">Δρόμος συλλέκτης / μέτριας κυκλοφορίας</option>
            <option value="3">Κύρια αρτηρία πόλης / υψηλής κυκλοφορίας</option>
            <option value="4">Πεζόδρομος</option>
          </select>
        </div>

        <div class="field large">
          <label for="nisida">Νησίδα:</label>
          <select class="form-control" id="nisida">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="zebra_painting">Ύπαρξη διαγράμμισης:</label>
          <select class="form-control" id="zebra_painting">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>
        <div class="field large">
          <label for="painting_date">Ημερομηνία τελευταίας διαγράμμισης:</label>
          <input class="form-control" type="date" id="painting_date">
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="street_lights_type">Τύπος φωτισμού δρόμου:</label>
          <select class="form-control" id="street_lights_type">
            <option value="">--Επιλέξτε--</option>
            <option value="1">cat's eye</option>
            <option value="2">Τύπου LED</option>
            <option value="3">Φωτεινές γραμμές</option>
          </select>
        </div>

        <div class="field large">
          <label for="sidewalk_light">Φωτισμός πεζοδρομίου:</label>
          <select class="form-control" id="sidewalk_light">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="traffic_signal">Φανάρι για ΑΜΕΑ:</label>
          <select class="form-control" id="traffic_signal">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>
        <div class="field large">
          <label for="signal_phase_duration">Διάρκεια πράσινου φωτός (δευτ.):</label>
          <input class="form-control" type="number" id="signal_phase_duration" min="0">
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="simansi_stylou">Σήμανση σε στύλο :</label>
          <select class="form-control" id="simansi_stylou">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>

        <div class="field large">
          <label for="sound_signal">Ηχητική σήμανση:</label>
          <select class="form-control" id="sound_signal">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="touch_device">Συσκευή αφής:</label>
          <select class="form-control" id="touch_device">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>
        <div class="field large">
          <label for="light_position">Φωτισμός θέσης:</label>
          <select class="form-control" id="light_position">
            <option value="">--Επιλέξτε--</option>
            <option value="1">Ναι</option>
            <option value="0">Όχι</option>
          </select>
        </div>
      </div>

      <div class="inline-fields">
        <div class="field large">
          <label for="image1">Φωτογραφία 1:</label>
          <input class="form-control" id="image1" name="image1" type="file">
        </div>
        <div class="field large">
          <label for="image2">Φωτογραφία 2:</label>
          <input class="form-control" id="image2" name="image2" type="file">
        </div>
      </div>

      <label for="street_view">Street View URL:</label>
      <input class="form-control" id="street_view" type="url">

      <label for="comments">Σχόλια:</label>
      <textarea class="form-control" id="comments" rows="3" placeholder="Προσθέστε τυχόν παρατηρήσεις…"></textarea>

      <div class="inline-fields">
        <div class="field large">
            <label for="crossing_latitude">Latitude:</label>
            <input class="form-control" type="text" id="crossing_latitude" readonly>
        </div>
        <div class="field large">
            <label for="crossing_longitude">Longitude:</label>
            <input class="form-control" type="text" id="crossing_longitude" readonly>
        </div>
      </div>
 
    `;
    

  } else if(category==="Ράμπες Πεζοδρομίων"){
    return `

      <div id="3" style="margin-top:5px; font-size:smaller; color:#555;">
          <span style="color:red">*</span> Υποχρεωτικά πεδία
      </div>
      <br>

      <div class="inline-fields">
          <div class="field large">
              <label for="odos" class="required">Οδός:</label>
              <input class="form-control" id="odos" type="text" required>
          </div>
          <div class="field large">
              <label for="arithmos" class="required">Αριθμός:</label>
              <input class="form-control" id="arithmos" type="text" required>
          </div>
      </div>

      <div class="inline-fields">

      <div class="field large">
        <label for="dimotiki_enotita_id">Δημοτική Ενότητα: </label>
        <select class="form-control" id="dimotiki_enotita_id">
          <option value="">--Επιλέξτε--</option>
          <!-- Οι επιλογές θα γεμίσουν δυναμικά -->
        </select>
      </div>
      </div>

      <div class="inline-fields">
          <div class="field large">
              <label for="length">Μήκος Ράμπας (m):</label>
              <input class="form-control" id="length" type="number" step="0.01">
          </div>

          <div class="field large">
              <label for="width">Πλάτος Ράμπας (m):</label>
              <input class="form-control" id="width" type="number" step="0.01">
          </div>

          <div class="field large">
              <label for="slope">Κλίση ράμπας:</label>
              <input class="form-control" id="slope" type="number" step="0.01">
          </div>
      </div>

      <div class="inline-fields">
          <div class="field large">
              <label for="ground_marking">Σήμανση στο οδόστρωμα:</label>
              <select class="form-control" id="ground_marking">
                  <option value="">--Επιλέξτε--</option>
                  <option value="1">Ναι</option>
                  <option value="0">Όχι</option>
              </select>
          </div>

          <div class="field large">
              <label for="light_position" title="Ύπαρξη ικανοποιητικού φωτισμού θέσης">Φωτισμός θέσης:</label>
              <select class="form-control" id="light_position">
                  <option value="">--Επιλέξτε--</option>
                  <option value="1">Ναι</option>
                  <option value="0">Όχι</option>
              </select>
          </div>
      </div>

      <div class="inline-fields">
          <div class="field large">
              <label for="image1">Φωτογραφία 1:</label>
              <input class="form-control" id="image1" name="image1" type="file">
          </div>
          <div class="field large">
              <label for="image2">Φωτογραφία 2:</label>
              <input class="form-control" id="image2" name="image2" type="file">
          </div>
      </div>

      <div class="inline-fields">
          <div class="field large">
              <label for="street_view">Street View URL:</label>
              <input class="form-control" id="street_view" type="url">
          </div>
      </div>

      <div class="inline-fields">
          <div class="field large">
              <label for="comments">Σχόλια:</label>
              <textarea class="form-control" id="comments" rows="3" placeholder="Προσθέστε τυχόν παρατηρήσεις…"></textarea>
          </div>
      </div>

      <div class="inline-fields">
          <div class="field large">
              <label for="ped_ramp_latitude">Latitude:</label>
              <input class="form-control" type="text" id="ped_ramp_latitude" readonly>
          </div>
          <div class="field large">
              <label for="ped_ramp_longitude">Longitude:</label>
              <input class="form-control" type="text" id="ped_ramp_longitude" readonly>
          </div>
      </div>

    `;


  } else if(category==="Ράμπες Εισόδου Κτιρίων"){
    return `

    <div id="4" style="margin-top:5px; font-size:smaller; color:#555;">
      <span style="color:red">*</span> Υποχρεωτικά πεδία
    </div>
    <br>

    <!-- Διεύθυνση -->
    <div class="inline-fields">
      <div class="field large">
        <label for="odos" class="required">Οδός:</label>
        <input class="form-control" id="odos" type="text" required>
      </div>
      <div class="field large">
        <label for="arithmos" class="required">Αριθμός:</label>
        <input class="form-control" id="arithmos" type="text" required>
      </div>
    </div>

    <div class="inline-fields">
      
      <div class="field large">
        <label for="dimotiki_enotita_id">Δημοτική Ενότητα: </label>
        <select class="form-control" id="dimotiki_enotita_id">
          <option value="">--Επιλέξτε--</option>
          <!-- Οι επιλογές θα γεμίσουν δυναμικά -->
        </select>
      </div>
    </div>

    <!-- Διαστάσεις και ράμπα -->
    <div class="inline-fields">
      <div class="field large">
        <label for="length">Μήκος ράμπας (m):</label>
        <input class="form-control" id="length" type="number" step="0.01">
      </div>
      <div class="field large">
        <label for="width">Πλάτος ράμπας (m):</label>
        <input class="form-control" id="width" type="number" step="0.01">
      </div>
      <div class="field large">
        <label for="slope">Κλίση ράμπας (%):</label>
        <input class="form-control" id="slope" type="number" step="0.01">
      </div>
    </div>

    <!-- Νέα πεδία για πόρτα και tactile -->
    <div class="inline-fields">
      <div class="field large">
        <label for="door_width">Πλάτος ελεύθερης διέλευσης πόρτας (m):</label>
        <input class="form-control" id="door_width" type="number" step="0.01">
      </div>
      <div class="field large">
        <label for="door_type">Τύπος πόρτας:</label>
        <select class="form-control" id="door_type">
          <option value="">--Επιλέξτε--</option>
          <option value="1">Χειροκίνητη</option>
          <option value="2">Συρόμενη</option>
          <option value="3">Αυτόματη</option>
        </select>
      </div>
      <div class="field large">
        <label for="push_button">Κουμπί ανοίγματος πόρτας:</label>
        <select class="form-control" id="push_button">
          <option value="">--Επιλέξτε--</option>
          <option value="1">Ναι</option>
          <option value="0">Όχι</option>
        </select>
      </div>
    </div>

    <div class="inline-fields">
      <div class="field large">
        <label for="tactile_paving">Οδηγός τυφλών (Tactile paving):</label>
        <select class="form-control" id="tactile_paving">
          <option value="">--Επιλέξτε--</option>
          <option value="1">Ναι</option>
          <option value="0">Όχι</option>
        </select>
      </div>
    </div>

    <!-- Υπόλοιπα στοιχεία -->
    <div class="inline-fields">
      <div class="field large">
        <label for="handrails">Χερούλια Στήριξης:</label>
        <select class="form-control" id="handrails">
          <option value="">--Επιλέξτε--</option>
          <option value="0">Όχι</option>
          <option value="1">Μεταλλική</option>
          <option value="2">Χτιστή</option>
          <option value="3">Ξύλινη</option>
        </select>
      </div>
      <div class="field large">
        <label for="roof">Στέγαση:</label>
        <select class="form-control" id="roof">
          <option value="">--Επιλέξτε--</option>
          <option value="1">Ναι</option>
          <option value="0">Όχι</option>
        </select>
      </div>
    </div>

    <div class="inline-fields">
      <div class="field large">
        <label for="ground_marking">Σήμανση στο οδόστρωμα:</label>
        <select class="form-control" id="ground_marking">
          <option value="">--Επιλέξτε--</option>
          <option value="1">Ναι</option>
          <option value="0">Όχι</option>
        </select>
      </div>
      <div class="field large">
        <label for="simansi_styloy">Σήμανση στο πεζοδρόμιο (επί στύλου):</label>
        <select class="form-control" id="simansi_styloy">
          <option value="">--Επιλέξτε--</option>
          <option value="1">Ναι</option>
          <option value="0">Όχι</option>
        </select>
      </div>
    </div>

    <div class="inline-fields">
      <div class="field large">
        <label for="lighting">Φωτισμός θέσης:</label>
        <select class="form-control" id="lighting">
          <option value="">--Επιλέξτε--</option>
          <option value="1">Ναι</option>
          <option value="0">Όχι</option>
        </select>
      </div>
    </div>

    <!-- Φωτογραφίες, street view, σχόλια -->
    <div class="inline-fields">
      <div class="field large">
        <label for="image1">Φωτογραφία 1:</label>
        <input class="form-control" id="image1" name="image1" type="file">
      </div>
      <div class="field large">
        <label for="image2">Φωτογραφία 2:</label>
        <input class="form-control" id="image2" name="image2" type="file">
      </div>
    </div>

    <div class="inline-fields">
      <div class="field large">
        <label for="street_view">Street View URL:</label>
        <input class="form-control" id="street_view" type="url">
      </div>
    </div>

    <div class="inline-fields">
      <div class="field large">
        <label for="comments">Σχόλια:</label>
        <textarea class="form-control" id="comments" rows="3" placeholder="Προσθέστε τυχόν παρατηρήσεις…"></textarea>
      </div>
    </div>

    <div class="inline-fields">
      <div class="field large">
        <label for="building_ramp_latitude">Latitude:</label>
        <input class="form-control" type="text" id="building_ramp_latitude" readonly>
      </div>
      <div class="field large">
        <label for="building_ramp_longitude">Longitude:</label>
        <input class="form-control" type="text" id="building_ramp_longitude" readonly>
      </div>
    </div>
    
    `;
  }
}  