//geocode.js

// Αναζήτηση Διεύθυνσης
function normalizeGreekAddress(address) {
    return address.normalize("NFD").replace(/[\u0300-\u036f]/g, "").toLowerCase();
}

function geocodeAddress() {
    const input = document.getElementById("searchInput").value.trim();
    if (!input) {
        alert("Παρακαλώ εισάγετε διεύθυνση!");
        return;
    }

    const address = normalizeGreekAddress(input);

    geocoder.geocode({ address: address }, function (results, status) {
        if (status === "OK") {
            map.setCenter(results[0].geometry.location);

            if (marker) marker.setMap(null);

            marker = new google.maps.Marker({
                map: map,
                position: results[0].geometry.location
            });

            marker.addListener("click", () => {
                if (editMode) {
                    openPopup(marker.getPosition().lat(), marker.getPosition().lng(), "Χώροι Στάθμευσης");
                }
            });

        } else {
            alert("Η αναζήτηση απέτυχε: " + status);
        }
    });
}
