<?php
//get_dim_enot.php

header('Content-Type: application/json');
session_start();

require_once __DIR__ . '/db.php';

// Έλεγχος login
if (!isset($_SESSION['user_id'], $_SESSION['dimos_id'])) {
    echo json_encode([
        'status' => false,
        'message' => 'Unauthorized'
    ]);
    exit;
}

$dimos_id = $_SESSION['dimos_id'];

$sql = "
    SELECT id, onoma
    FROM dimotiki_enotita
    WHERE dimos_id = :dimos_id
    ORDER BY onoma
";

$stmt = $pdo->prepare($sql);
$stmt->execute([':dimos_id' => $dimos_id]);

$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Έλεγχος ονομάτων
foreach ($data as &$row) {
    $row['onoma'] = htmlspecialchars($row['onoma'], ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}
unset($row);

echo json_encode($data, JSON_UNESCAPED_UNICODE);

