<?php
// get_markers.php

session_start();
require_once __DIR__ . '/db.php'; 

error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
header('Content-Type: application/json');

// Έλεγχος αν ο χρήστης έχει συνδεθεί και έχει dimos_id
if (!isset($_SESSION['dimos_id'])) {
    echo json_encode([]);
    exit;
}

$dimos_id = (int)$_SESSION['dimos_id'];

// Πίνακες ανά κατηγορία
$categoryTableMap = [
    'Χώροι Στάθμευσης' => 'parking',
    'Διαβάσεις' => 'crossings',
    'Ράμπες Πεζοδρομίων' => 'pedestrian_ramps',
    'Ράμπες Εισόδου Κτιρίων' => 'building_ramps'
];

$allRows = [];

foreach ($categoryTableMap as $category => $table) {
    $sql = "
        SELECT t.*, ST_Y(t.geom) AS lat, ST_X(t.geom) AS lng
        FROM $table t
        JOIN dimos d ON d.id = :dimos_id
        WHERE ST_Within(t.geom, d.geom)
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([':dimos_id' => $dimos_id]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Έλεγχος για ποφυγή ειδκών χαρκτήρων
    foreach ($rows as &$row) {
        unset($row['geom']);
        $row['category'] = htmlspecialchars($category, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
        foreach ($row as $key => $value) {
            if (is_string($value)) {
                $row[$key] = htmlspecialchars($value, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
            }
        }
    }
    unset($row);

    $allRows = array_merge($allRows, $rows);
}

echo json_encode($allRows);
exit;
