<?php
// index.php

session_start();
require_once __DIR__ . '/db.php'; 

// Αν δεν υπάρχει session, επιστροφή σε login
if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="el">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Χάρτης Προσβασιμότητας - Google Maps</title>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">

<style>
/* ===== Global ===== */
html, body { 
    margin: 0; 
    padding: 0; 
    height: 100%; 
    font-family: Arial, sans-serif; 
    overflow: hidden; 
}

#map { 
    width: 100%; 
    height: calc(100vh - 70px); 
    position: relative; 
}

/* ===== Popup Form ===== */
.popup-form { 
    background: #fff; 
    padding: 20px; 
    border-radius: 10px; 
    box-shadow: 0 0 15px rgba(0,0,0,0.3); 
    width: 600px; 
    max-width: 95%; 
    max-height: 90vh; 
    overflow-y: auto; 
}

#markerTable { 
    margin: 20px auto; 
    width: 95%; 
}

#markerTable th, 
#markerTable td { 
    text-align: center; 
    vertical-align: middle; 
}

/* ===== Map Legend ===== */
#map-legend {
    position: absolute; 
    top: 100px; 
    left: 20px; 
    width: 250px; 
    z-index: 9999;
    background: rgba(255,255,255,0.95); 
    border: 2px solid #001f4d; 
    backdrop-filter: blur(8px);
    border-radius: 16px; 
    box-shadow: 0 15px 35px rgba(0,0,0,0.25);
    font-family: 'Segoe UI', Tahoma, sans-serif;
}

#map-legend .legend-header { 
    display: flex; 
    justify-content: space-between; 
    align-items: center; 
    padding: 12px 14px; 
    font-weight: 700; 
    color: #003366; 
    border-bottom: 1px solid #e0e0e0; 
}

#map-legend .legend-header button { 
    border: none; 
    background: #003366; 
    color: #fff; 
    border-radius: 8px; 
    width: 26px; 
    height: 26px; 
    cursor: pointer; 
}

#map-legend.closed .legend-header { 
    border-bottom: none; 
}

#map-legend .legend-body { 
    padding: 12px 14px; 
}

.legend-item { 
    display: flex; 
    align-items: center; 
    gap: 8px; 
    font-size: 13px; 
    margin-bottom: 10px; 
    cursor: pointer; 
}

.legend-item img { 
    width: 26px; 
    height: 26px; 
}

.legend-item input { 
    accent-color: #003366; 
}

/* ===== Edit Mode Button ===== */
#editModeBtn { 
    background: rgba(255,255,255,0.95); 
    backdrop-filter: blur(8px); 
    border-radius: 14px;
    padding: 10px 16px; 
    font-family: 'Segoe UI', Tahoma, sans-serif; 
    font-weight: 700; 
    color: #003366;
    border: 2px solid #003366; 
    box-shadow: 0 8px 20px rgba(0,0,0,0.2); 
    cursor: pointer; 
    transition: all 0.3s ease;
}

#editModeBtn.on { 
    background: #003366; 
    color: #fff; 
    border: 2px solid #001f4d; 
    box-shadow: 0 8px 20px rgba(0,0,0,0.3); 
}

#editModeBtn:hover { 
    transform: translateY(-2px); 
    box-shadow: 0 12px 25px rgba(0,0,0,0.35); 
}

/* ===== Forms & Grids ===== */
.form-grid { 
    display: grid; 
    grid-template-columns: 150px 1fr; 
    gap: 10px 20px; 
    align-items: center; 
}

.form-grid label { 
    font-weight: bold; 
}

.form-grid input[type="text"], 
.form-grid input[type="number"], 
.form-grid input[type="file"], 
.form-grid textarea { 
    width: 100%; 
    padding: 5px; 
    box-sizing: border-box; 
}

.form-grid input[type="checkbox"] { 
    width: auto; 
    margin-left: 0; 
}

.form-grid textarea { 
    resize: vertical; 
}

.save-btn { 
    grid-column: 1 / span 2; 
    margin-top: 15px; 
}

label.required::after { 
    content: " *"; 
    color: red; 
}

#entitySelect { 
    font-weight: 100; 
    font-size: 16px; 
    color: #003366; 
}

.inline-fields { 
    display: flex; 
    gap: 10px; 
    align-items: flex-end; 
    margin-bottom: 10px; 
}

.inline-fields .field { 
    display: flex; 
    flex-direction: column; 
}

.inline-fields .field.small { 
    flex: 1; 
}

.inline-fields .field.large { 
    flex: 2; 
}

.error-message { 
    color: red; 
    font-size: 12px; 
    margin-top: 2px; 
    display: block; 
}

.crosshair-cursor { 
    cursor: crosshair; 
}

/* ===== Navbar ===== */
.navbar { 
    margin-bottom: 0 !important; 
}

.navbar.navbar-default { 
    min-height: 56px !important; 
    padding: 6px 16px !important; 
    background: linear-gradient(90deg,#003366,#0055a5) !important; 
    border: none !important; 
    border-radius: 0; 
    box-shadow: 0 2px 8px rgba(0,0,0,0.15); 
}

.navbar-default .navbar-nav > li > a, 
.navbar-default .navbar-brand { 
    color: #fff !important; 
    font-weight: 500; 
}

.navbar-default .navbar-nav > li > a:hover { 
    background: rgba(255,255,255,0.12) !important; 
}

.navbar .container-fluid, 
.navbar-header, 
.navbar-nav { 
    padding-top: 0 !important; 
    padding-bottom: 0 !important; 
}

.navbar-center { 
    position: absolute; 
    left: 50%; 
    transform: translateX(-50%); 
    top: 5px; 
}

.navbar-center .form-control { 
    height: 32px; 
    font-size: 13px; 
    padding: 4px 10px; 
    border-radius: 6px; 
    border: none; 
}

.navbar-center button { 
    height: 32px; 
    font-size: 13px; 
    padding: 4px 12px; 
    border-radius: 6px; 
    border: none; 
    background: #fff; 
    color: #003366; 
    font-weight: 600; 
}

.navbar-center button:hover { 
    background: #e3f2fd; 
}

/* ===== Avatar & User Pill ===== */
.gov-avatar { 
    width: 32px; 
    height: 32px; 
    line-height: 32px; 
    background: #fff; 
    color: #003366; 
    font-weight: bold; 
    text-align: center; 
    border-radius: 50%; 
    display: inline-block; 
    margin-right: 6px; 
}

.user-pill { 
    display: inline-flex; 
    align-items: center; 
    gap: 6px; 
    padding: 4px 10px; 
    background: #003366; 
    border-radius: 20px; 
    color: #fff; 
    font-weight: 500; 
}

/* ===== Home icon ===== */
.home-icon { 
    display: inline-flex; 
    align-items: center; 
    justify-content: center;
    width: 32px; 
    height: 32px; 
    background: #fff; 
    border-radius: 6px; 
    margin-right: 10px; 
    margin-top: 12px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.15); 
    transition: all 0.2s ease; 
}

.home-icon svg { 
    width: 24px; 
    height: 24px; 
    fill: #003366; 
    transition: transform 0.2s, fill 0.2s; 
}

.home-icon:hover svg { 
    transform: scale(1.2); 
    fill: #0055a5; 
}

.home-icon:active { 
    transform: scale(0.95); 
}

/* ===== Google Maps InfoWindow ===== */
.gm-style-iw a, 
.gm-style-iw button { 
    display: inline-block !important; 
    padding: 5px 10px !important; 
    background-color: #0055a5 !important; 
    color: #fff !important; 
    text-decoration: none !important; 
    border-radius: 4px !important; 
    font-size: 12px !important; 
    font-weight: bold !important; 
    text-align: center !important; 
    outline: none !important; 
    box-shadow: none !important; 
    cursor: pointer; 
    transition: background 0.2s; 
}

.gm-style-iw a:hover, 
.gm-style-iw button:hover { 
    background-color: #003366 !important; 
}

.gm-style-iw a[href][target="_blank"] { 
    background: none !important; 
    color: #003366 !important; 
    padding: 0 !important; 
    border: none !important; 
    font-weight: normal !important; 
    text-decoration: underline !important; 
}

.gm-style-iw .gm-ui-hover-effect { 
    width: 20px !important; 
    height: 20px !important; 
    top: 8px !important; 
    right: 8px !important; 
    display: flex !important; 
    align-items: center !important; 
    justify-content: center !important; 
    padding: 0 !important; 
    margin: 0 !important; 
    box-sizing: border-box; 
    background: #b71c1c !important; 
    border-radius: 4px !important; 
}

.gm-style-iw .gm-ui-hover-effect > span { 
    width: 12px !important; 
    height: 12px !important; 
    margin: 0 !important; 
    filter: invert(1) brightness(2); 
}

.gm-style-iw .gm-ui-hover-effect:hover { 
    background: #b71c1c !important; 
}

.gm-style-iw .deleteMarkerBtn { 
    background: #b71c1c !important; 
    color: #fff !important; 
    border: 1px solid #800000 !important; 
    border-radius: 4px !important; 
    padding: 5px 10px !important; 
    font-size: 12px !important; 
    cursor: pointer !important; 
}

.gm-style-iw .deleteMarkerBtn:hover { 
    background: #d32f2f !important; 
}

.gm-style-iw table { 
    border-collapse: collapse !important; 
    margin: 0 !important; 
    font-size: 12px !important; 
}

.gm-style-iw table.table-borderless, 
.gm-style-iw table.table-borderless td, 
.gm-style-iw table.table-borderless th { 
    border: none !important; 
    padding: 2px 4px !important; 
}

.gm-style-iw table.table-hover tbody tr:hover { 
    background-color: rgba(0,86,165,0.1) !important; 
}

.gm-style-iw td { 
    padding: 2px 4px !important; 
    white-space: nowrap !important; 
}

/* ===== Sienna iframe ===== */
iframe[src*="sienna"] { 
    opacity: 0.65; 
}

iframe[src*="sienna"]:hover { 
    opacity: 1; 
}

</style>

</head>

<body>
   
<nav class="navbar navbar-default">
  
  <div class="container-fluid">
    <a href="index.php" class="home-icon" title="Αρχική">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
            <path d="M12 3l10 9h-3v9h-6v-6h-2v6H5v-9H2z"/>
        </svg>
    </a>

    <div class="navbar-center" style="margin-top:15px;">
  <input id="searchInput" title= "Εισάγετε διεύθυνση και πόλη ή ΤΚ" placeholder="Εισάγετε διεύθυνση π.χ. Ερμού 68, Αθήνα " type="search" class="form-control" style="width:300px; display:inline-block;">
  <button onclick="geocodeAddress()">Αναζήτηση</button>
</div>
    <ul class="nav navbar-nav navbar-right">
      <li class="dropdown">
        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
          <?php
            $username = $_SESSION['username'] ?? 'U';
            // Αρχικό ονόματος χρήστη για avatar 
            $initials = '';
            if(strpos($username, ' ') !== false){
                $parts = explode(' ', $username);
                $initials = strtoupper($parts[0][0] . $parts[1][0]);
            } else {
                $initials = strtoupper(substr($username,0,1));
            }
          ?>
          <span class="user-pill">
            <span id="userAvatar" class="gov-avatar"><?= htmlspecialchars($initials) ?></span>
            <?= htmlspecialchars($username) ?>
          </span>

        </a>
        <ul class="dropdown-menu">
 
          <li><a href="logout.php">Αποσύνδεση</a></li>
        </ul>
      </li>
    </ul>

  </div>
</nav>
<div id="deleteAlertContainer" style="position:fixed; top:10px; left:50%; transform:translateX(-50%); z-index:9999;"></div>
<div id="map"></div>
<div id="formContainer" 
     style="display:none; position:absolute; top:20px; left:20px;
     background:white; padding:20px; border-radius:10px;
     z-index:9999; box-shadow:0 0 10px rgba(0,0,0,0.3);">
</div>



<script>
window.loggedUser = {
    user_id: <?= json_encode($_SESSION['user_id']) ?>,
    dimos_id: <?= json_encode($_SESSION['dimos_id']) ?>,
    centroid_lat: <?= json_encode($_SESSION['centroid_lat']) ?>,
    centroid_lng: <?= json_encode($_SESSION['centroid_lng']) ?>,
    zoom: 14
};
</script>

<!-- Sienna Accessibility -->
<script src="https://cdn.jsdelivr.net/npm/sienna-accessibility@latest/dist/sienna-accessibility.umd.js" defer></script>

<script>
document.addEventListener("DOMContentLoaded", () => {
  if (window.SiennaAccessibility) {
    window.SiennaAccessibility.init({
      position: 'bottom-right',
      size: 'small'   
    });
  }
});
</script>
<script src="popup_labels.js"></script>
<script src="fields.js"></script>
<script src="map_features.js"></script>
<script src="geocode.js"></script>
<div id="alertContainer" style="position:absolute; top:10px; left:50%; transform:translateX(-50%); z-index:1000; width:400px;"></div>
<script src="helper_fuctions.js"></script>
<script src="create_markers.js"></script>
<script src="info_window.js"></script>
<script src="edit_markers.js"></script>
<script async defer
    src="https://maps.googleapis.com/maps/api/js?key=<?= $googleMapsApiKey ?>&callback=initMap">
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
<script src="https://unpkg.com/tokml/tokml.js"></script>

</body>
</html>