// map_features.js
let map;
let geocoder;
let editMode = false;

const categories = [
    "Χώροι Στάθμευσης",
    "Διαβάσεις",
    "Ράμπες Πεζοδρομίων",
    "Ράμπες Εισόδου Κτιρίων"
];

const categoryIcons = {
    "Χώροι Στάθμευσης": "icons_map/parking-sign_pin.png",
    "Διαβάσεις": "icons_map/ped_pin2.png",
    "Ράμπες Πεζοδρομίων": "icons_map/ramp_pin3.png",
    "Ράμπες Εισόδου Κτιρίων": "icons_map/ramp_16_pin.png"
};

window.initMap = function() {
    if (!window.loggedUser) {
        console.error('loggedUser is not defined!');
        return;
    }

    const centerLat = loggedUser.centroid_lat;
    const centerLng = loggedUser.centroid_lng;

    map = new google.maps.Map(document.getElementById('map'), {
        center: { lat: centerLat, lng: centerLng },
        zoom: loggedUser.zoom
    });

    geocoder = new google.maps.Geocoder();

    // Legend Panel
    const legendPanel = document.createElement('div');
    legendPanel.id = 'map-legend';
    legendPanel.innerHTML = `
        <div class="legend-header">
            <span>Υπόμνημα Χάρτη</span>
            <button id="legendToggleBtn">–</button>
        </div>
        <div class="legend-body">
            ${categories.map(cat => `
            <label class="legend-item">
                <input type="checkbox" data-category="${cat}" checked>
                <img src="${categoryIcons[cat]}" />
                <span>${cat}</span>
            </label>
            `).join('')}
        </div>
    `;
    document.getElementById('map').appendChild(legendPanel);

    let legendOpen = true;
    document.getElementById('legendToggleBtn').addEventListener('click', () => {
        legendOpen = !legendOpen;
        const legend = document.getElementById('map-legend');
        legend.querySelector('.legend-body').style.display = legendOpen ? 'block' : 'none';
        legend.classList.toggle('closed', !legendOpen);
    });

    const checkboxes = {};
    document.querySelectorAll('#map-legend input[type="checkbox"]').forEach(cb => {
        const cat = cb.dataset.category;
        checkboxes[cat] = cb;
    });

    const markersByCategory = {};
    categories.forEach(cat => markersByCategory[cat] = []);

    // Φόρτωση markers από βάση δεδομένων
    fetch('/va/get_markers.php')
        .then(res => res.json())
        .then(rows => {
            if (!Array.isArray(rows)) {
                console.error('Δε λάβαμε πίνακα από DB:', rows);
                return;
            }

            rows.forEach(data => {
                const lat = parseFloat(data.lat);
                const lng = parseFloat(data.lng);
                if (isNaN(lat) || isNaN(lng)) return;

                const category = data.category;
                const iconUrl = categoryIcons[category];
                if (!iconUrl) return;

                const marker = new google.maps.Marker({
                    position: { lat, lng },
                    map: checkboxes[category].checked ? map : null,
                    icon: { url: iconUrl, scaledSize: new google.maps.Size(36, 36) }
                });

                data.marker = marker;
                markersByCategory[category].push(marker);

                attachInfoWindow(marker, data);
            });

            // Toggle markers με checkboxes 
            categories.forEach(category => {
                checkboxes[category].addEventListener('change', () => {
                    markersByCategory[category].forEach(marker => {
                        marker.setMap(checkboxes[category].checked ? map : null);
                    });
                });
            });
        })
        .catch(err => console.error('Σφάλμα φόρτωσης markers από DB:', err));


    // Edit Mode Button 
    const editBtnDiv = document.createElement('div');
    editBtnDiv.id = 'editModeBtnDiv';
    editBtnDiv.style.position = 'absolute';
    editBtnDiv.style.bottom = '100px'; 
    editBtnDiv.style.left = '20px';    
    editBtnDiv.style.zIndex = '10002'; 

    const editBtn = document.createElement('button');
    editBtn.id = 'editModeBtn';
    editBtn.textContent = 'Edit Mode: OFF';
    editBtnDiv.appendChild(editBtn);

    document.getElementById('map').appendChild(editBtnDiv);

    let editMode = false;
    editBtn.addEventListener('click', () => {
        editMode = !editMode;
        editBtn.textContent = editMode ? 'Edit Mode: ON' : 'Edit Mode: OFF';
        editBtn.classList.toggle('on', editMode);
        map.setOptions({ draggableCursor: editMode ? 'crosshair' : null });
        if (editMode) document.getElementById('map').classList.add('crosshair-cursor');
        else document.getElementById('map').classList.remove('crosshair-cursor');
        if (!editMode) document.querySelectorAll('.popup-form').forEach(f => f.remove());
    });

    // Map Click Listener για έλεγχο περιοχής 
    map.addListener('click', async (e) => {
        if (!editMode) return;

        const lat = e.latLng.lat();
        const lng = e.latLng.lng();

        try {
            const res = await fetch('/va/inota.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    user_id: loggedUser.id,
                    dimos_id: loggedUser.dimos_id,
                    lat, lng
                })
            });
            const result = await res.json();

            if (result.status === true) {
                console.log('Σημείο εντός δήμου ✔');
                openNewForm(lat, lng, "Χώροι Στάθμευσης");
            } else {
                const alertContainer = document.getElementById('alertContainer'); 
                alertContainer.innerHTML = `
                    <div class="alert alert-warning alert-dismissible fade in" role="alert">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        <strong>Προσοχή!</strong> Το σημείο βρίσκεται εκτός των ορίων του δήμου σας.
                    </div>
                `;
            }

        } catch (err) {
            console.error('Σφάλμα ελέγχου περιοχής:', err);
        }
    });
};
