<?php
// Εμφάνιση σφαλμάτων για debug
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Credentials PostgreSQL
$host = 'localhost';
$port = 5433;  
$dbname = 'postgres';
$user = 'postgres';
$pass = 'postgresse!';

try {
    $pdo = new PDO("pgsql:host=$host;port=$port;dbname=$dbname", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Query για δήμους
    $stmt = $pdo->query("SELECT id, comments FROM dimos ORDER BY comments ASC");
    $dimos_list = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Επιστροφή JSON
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($dimos_list);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'PDOException: ' . $e->getMessage()]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Exception: ' . $e->getMessage()]);
}
?>
