<?php
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
header('Content-Type: application/json');

try {
    $pdo = new PDO(
        'pgsql:host=localhost;port=5433;dbname=postgres',
        'postgres',
        'postgresse!'
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode([]);
    exit;
}

// Χάρτης κατηγορίας πίνακας
$categoryTableMap = [
    'Χώροι Στάθμευσης' => 'parking',
    'Διαβάσεις' => 'crossings',
    'Ράμπες Πεζοδρομίων' => 'pedestrian_ramps',
    'Ράμπες Εισόδου Κτιρίων' => 'building_ramps'
];

$allRows = [];

foreach ($categoryTableMap as $category => $table) {

    // Κρατάμε SELECT αλλά ΠΡΟΣΘΕΤΟΥΜΕ lat / lng
    $sql = "SELECT *, ST_Y(geom) AS lat, ST_X(geom) AS lng FROM $table";
    $stmt = $pdo->query($sql);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($rows as &$row) {
        unset($row['geom']);      
        $row['category'] = $category;
    }
    unset($row); 

    $allRows = array_merge($allRows, $rows);
}

echo json_encode($allRows);