<?php
// homepage.php
// ===========================
// Άμεση σύνδεση στη βάση με credentials
$host = 'localhost';
$port = 5433;
$dbname = 'postgres';
$user = 'postgres';
$pass = 'postgresse!';

try {
    $pdo = new PDO("pgsql:host=$host;port=$port;dbname=$dbname", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e){
    die("Σφάλμα σύνδεσης βάσης: " . $e->getMessage());
}

// Παίρνουμε μόνο id και onoma
$dimos_list = $pdo->query("SELECT id, onoma FROM dimos ORDER BY onoma")->fetchAll(PDO::FETCH_ASSOC);
?>


<!DOCTYPE html>
<html lang="el">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Ψηφιακή Πύλη Προσβασιμότητας</title>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<style>
html, body { margin:0; padding:0; height:100%; font-family:'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background: linear-gradient(135deg, #e3f2fd, #ffffff); overflow: hidden; }
.page-wrapper { height:100%; display:flex; flex-direction:column; justify-content:center; align-items:center; text-align:center; }
.btn-primary { background:#42a5f5; border:none; border-radius:8px; padding:12px 25px; font-weight:600; transition:0.3s; }
.btn-primary:hover { background:#1e88e5; transform:translateY(-2px); }
.icon-row { display:flex; justify-content:center; flex-wrap:wrap; margin-top:50px; }
.icon-row img { width:80px; height:80px; margin:15px; object-fit:contain; }
.page-footer { position:fixed; bottom:10px; right:15px; font-size:13px; color:#555; text-align:right; z-index:1000; }
.page-footer a { text-decoration:underline; color:#42a5f5; }
.page-footer a:hover { color:#1e88e5; }
</style>
</head>
<body>

<div class="page-wrapper container text-center">
    <h1>Ψηφιακή Πύλη Προσβασιμότητας</h1>

    <form action="/va_open/index.php" method="get" style="margin-top: 30px;">
        <select name="dimos_id" class="form-control" style="width: 300px; margin:0 auto 20px auto;" required>
            <option value="" disabled selected>Επιλέξτε Δήμο</option>
            <?php foreach($dimos_list as $dimos): ?>
                <option value="<?= $dimos['id'] ?>">
                    <?= htmlspecialchars($dimos['onoma']) ?>
                </option>
            <?php endforeach; ?>
        </select>

        <button type="submit" class="btn btn-primary btn-lg">Είσοδος στην Υπηρεσία</button>
    </form>

    <div class="icon-row">
        <img src="icons/audio-description-accessibility-icon.png" alt="Audio Description">
        <img src="icons/braille-accessibility-icon.png" alt="Braille">
        <img src="icons/closed-caption-accessibility-icon.png" alt="Closed Captions">
        <img src="icons/wheelchair-accessibility-icon.png" alt="Accessibility Icon">
        <img src="icons/low-vision-accessibility-icon.png" alt="Low Vision">
        <img src="icons/sign-language-accessibility-icon.png" alt="Sign Language">
    </div>
</div>

<!-- Footer κάτω αριστερά -->
<footer class="page-footer">
  <strong>Δημόσιοι Φορείς</strong><br>
  <a href="https://www.gov.gr/" target="_blank">gov.gr</a> |
  <a href="https://data.gov.gr/" target="_blank">data.gov.gr</a> |
  <a href="https://sdigmap.tee.gov.gr/erga/" target="_blank">Εθνικό Μητρώο Υποδομών</a><br>
  WCAG 2.1 AA – 
  <a href="https://www.w3.org/WAI/WCAG21/quickref/" target="_blank">Πληροφορίες</a>
</footer>

<!-- Sienna Accessibility widget (κάτω δεξιά) -->
<script src="https://cdn.jsdelivr.net/npm/sienna-accessibility@latest/dist/sienna-accessibility.umd.js" defer></script>
<script>
document.addEventListener("DOMContentLoaded", () => {
    if (window.SiennaAccessibility) {
      window.SiennaAccessibility.init({
        position: 'bottom-right' // κάτω δεξιά
      });
    }
});
</script>

</body>
</html>
