<?php
session_start();
$host = "localhost";
$port = 5433;           // το port που χρησιμοποιείς
$dbname = "postgres";   // το όνομα της βάσης
$user = "postgres";     // username
$pass = "postgresse!";  // passwordpgsql:host=localhost;port=5433;dbname=postgres', 'postgres', 'postgresse!');


try {
    $pdo = new PDO("pgsql:host=$host;port=$port;dbname=$dbname", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e){
    die("Σφάλμα σύνδεσης βάσης: " . $e->getMessage());
}


// Αν υπάρχει GET με dimos_id (από επιλογή χρήστη)
if(isset($_GET['dimos_id'])){
    $dimos_id = (int)$_GET['dimos_id'];

    $stmt = $pdo->prepare("
        SELECT ST_Y(centroid) AS lat, ST_X(centroid) AS lng
        FROM dimos
        WHERE id = :dimos_id
    ");
    $stmt->execute([':dimos_id' => $dimos_id]);
    $dimos = $stmt->fetch(PDO::FETCH_ASSOC);

    if($dimos){
        $_SESSION['dimos_id'] = $dimos_id;
        $_SESSION['centroid_lat'] = (float)$dimos['lat'];
        $_SESSION['centroid_lng'] = (float)$dimos['lng'];
        $_SESSION['zoom'] = 14; // προτεινόμενο zoom
    }
}

// fallback σε περίπτωση που δεν επιλέχθηκε δήμος
if(!isset($_SESSION['centroid_lat'])){
    $_SESSION['centroid_lat'] = 39.611; // κεντρικό fallback
    $_SESSION['centroid_lng'] = 21.694;
    $_SESSION['zoom'] = 7;
}
?>

<!DOCTYPE html>
<html lang="el">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Χάρτης Προσβασιμότητας - Google Maps</title>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">


<style>
/* ===== Global & Map ===== */
html, body {
    margin: 0;
    padding: 0;
    height: 100%;
    overflow: hidden; 
}

#map {
    width: 100%;
    height: 100vh; 
    position: relative;
}

body { 
    margin:0; 
    font-family: Arial, sans-serif; 
}

#map { 
    width:100%;
    height: calc(100vh - 70px); /* αφαιρούμε το ύψος του navbar */ 
}

/* ===== Popup Form ===== */
.popup-form { 
    background:white; 
    padding:20px; 
    border-radius:10px; 
    box-shadow:0 0 15px rgba(0,0,0,0.3); 
    width:600px; 
    max-width:95%; 
    max-height:90vh; 
    overflow-y:auto; 
}

#markerTable { 
    margin:20px auto; 
    width:95%; 
}

#markerTable th, #markerTable td { 
    text-align:center; 
    vertical-align:middle; 
}

/* ===== Map Legend ===== */
#map-legend {
    position: absolute;
    top: 100px;
    left: 20px;
    width: 250px;
    z-index: 9999;
    background: rgba(255,255,255,0.95);
    border: 2px solid #001f4d;
    backdrop-filter: blur(8px);
    border-radius: 16px;
    box-shadow: 0 15px 35px rgba(0,0,0,0.25);
    font-family: 'Segoe UI', Tahoma, sans-serif;
}

/* Header */
#map-legend .legend-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 14px;
    font-weight: 700;
    color: #003366;
    border-bottom: 1px solid #e0e0e0;
}

#map-legend .legend-header button {
    border: none;
    background: #003366;
    color: white;
    border-radius: 8px;
    width: 26px;
    height: 26px;
    cursor: pointer;
}

#map-legend.closed .legend-header {
    border-bottom: none;
}

/* Body */
#map-legend .legend-body {
    padding: 12px 14px;
}

/* Items */
.legend-item {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 13px;
    margin-bottom: 10px;
    cursor: pointer;
}

.legend-item img {
    width: 26px;
    height: 26px;
}

.legend-item input {
    accent-color: #003366;
}


/* ===== Grid Forms ===== */
.form-grid {
    display: grid;
    grid-template-columns: 150px 1fr; 
    gap: 10px 20px; 
    align-items: center;
}

.form-grid label {
    font-weight: bold;
}

.form-grid input[type="text"],
.form-grid input[type="number"],
.form-grid input[type="file"],
.form-grid textarea {
    width: 100%;
    padding: 5px;
    box-sizing: border-box;
}

.form-grid input[type="checkbox"] {
    width: auto;
    margin-left: 0;
}

.form-grid textarea {
    resize: vertical;
}

.save-btn {
    grid-column: 1 / span 2; 
    margin-top: 15px;
}  

label {
    font-weight: bold;
}

#entitySelect {
    font-weight: 100;
    font-size: 16px;
    color: #003366; 
}

.inline-fields {
    display: flex;
    gap: 10px;
    align-items: flex-end;
    margin-bottom: 10px;
}

.inline-fields .field {
    display: flex;
    flex-direction: column;
}

.inline-fields .field.small {
    flex: 1;
}

.inline-fields .field.large {
    flex: 2;
}

.error-message {
    color: red;
    font-size: 12px;
    margin-top: 2px;
    display: block;
}

/* Cursor */
.crosshair-cursor {
    cursor: crosshair;
}

label.required::after {
    content: " *";
    color: red;
}

/* Navbar styles */
.navbar { margin-bottom: 0 !important; }

.navbar.navbar-default {
    min-height: 56px !important;
    padding: 6px 16px !important;
    background: linear-gradient(90deg, #003366, #0055a5) !important;
    border: none !important;
    border-radius: 0;
    box-shadow: 0 2px 8px rgba(0,0,0,0.15);
}

.navbar-default .navbar-nav > li > a,
.navbar-default .navbar-brand {
    color: #ffffff !important;
    font-weight: 500;
}

.navbar-default .navbar-nav > li > a:hover {
    background: rgba(255,255,255,0.12) !important;
}

.navbar .container-fluid,
.navbar-header,
.navbar-nav {
    padding-top: 0 !important;
    padding-bottom: 0 !important;
}

.navbar-center {
    position: absolute;
    left: 50%;
    transform: translateX(-50%);
    top: 5px; 
}

.navbar-center .form-control {
    height: 32px;
    font-size: 13px;
    padding: 4px 10px;
    border-radius: 6px;
    border: none;
}

.navbar-center button {
    height: 32px;
    font-size: 13px;
    padding: 4px 12px;
    border-radius: 6px;
    border: none;
    background: #ffffff;
    color: #003366;
    font-weight: 600;
}

.navbar-center button:hover {
    background: #e3f2fd;
}
.home-icon {
    display: inline-block;
    margin-right: 10px; /* απόσταση από ό,τι είναι δίπλα */
    vertical-align: middle;
}

.home-icon svg {
    width: 32px;       /* μεγαλύτερο */
    height: 32px;
    fill: white;       /* λευκό */
    transition: transform 0.2s, fill 0.2s;
}

.home-icon:hover svg {
    transform: scale(1.2);  /* ελαφρύ zoom στο hover */
    fill: #ffd700;           /* προαιρετικά χρυσό στο hover */
}

/* Avatar & User Pill */
.gov-avatar {
    width: 32px;
    height: 32px;
    font-size: 14px;
    line-height: 32px;
    background: #ffffff;
    color: #003366;
    font-weight: bold;
    text-align: center;
    border-radius: 50%;
    display: inline-block;
    margin-right: 6px;
}

.user-pill {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 4px 10px;
    background: #003366;
    border-radius: 20px;
    color: #fff;
    font-weight: 500;
}

/* Navbar back button */
.navbar-btn {
    background: #ffffff !important;
    border: none !important;
    color: #003366 !important;
    font-weight: 600;
    border-radius: 6px;
}

.navbar-btn:hover {
    background: #e3f2fd !important;
}

/* ===== Google Maps InfoWindow ===== */
.gm-style-iw a,
.gm-style-iw button {
    display: inline-block !important;
    padding: 5px 10px !important;
    background-color: #0055a5 !important;
    color: #fff !important;
    text-decoration: none !important;
    border-radius: 4px !important;
    font-size: 12px !important;
    font-weight: bold !important;
    text-align: center !important;
    outline: none !important;
    box-shadow: none !important;
    cursor: pointer;
    transition: background 0.2s;
}

.gm-style-iw a:hover,
.gm-style-iw button:hover {
    background-color: #003366 !important;
}

/* Link "Προβολή" */
.gm-style-iw a[href][target="_blank"] {
    background: none !important;
    color: #003366 !important;
    padding: 0 !important;
    border: none !important;
    font-weight: normal !important;
    text-decoration: underline !important;
}

/* Close button */
.gm-style-iw .gm-ui-hover-effect {
    width: 20px !important;
    height: 20px !important;
    top: 8px !important;
    right: 8px !important;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    padding: 0 !important;
    margin: 0 !important;
    box-sizing: border-box;
    background: #b71c1c !important;
    border-radius: 4px !important;
}

.gm-style-iw .gm-ui-hover-effect > span {
    width: 12px !important;
    height: 12px !important;
    margin: 0 !important;
    filter: invert(1) brightness(2);
}

.gm-style-iw .gm-ui-hover-effect:hover {
    background: #b71c1c !important;
}


</style>
</head>

<body>

     

<nav class="navbar navbar-default">
  
  <div class="container-fluid">
    <a href="index.php" class="home-icon" title="Αρχική">
        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="white" viewBox="0 0 24 24">
            <path d="M12 3l10 9h-3v9h-6v-6h-2v6H5v-9H2z"/>
        </svg>
    </a>

    <div class="navbar-center" style="margin-top:15px;">
  <input id="searchInput" title= "Εισάγετε διεύθυνση και πόλη ή ΤΚ" placeholder="Εισάγετε διεύθυνση π.χ. Ερμού 68, Αθήνα " type="search" class="form-control" style="width:300px; display:inline-block;">
  <button onclick="geocodeAddress()">Αναζήτηση</button>
</div>
    <ul class="nav navbar-nav navbar-right">
        <?php
// Φόρτωση των δήμων από τη βάση
$dimos_list = $pdo->query("SELECT id, onoma FROM dimos ORDER BY onoma")->fetchAll(PDO::FETCH_ASSOC);
?>
        <ul class="nav navbar-nav navbar-right">
            <li style="margin-top:8px;">
                <select id="dimosSelect" class="form-control" style="width:250px; height:32px; padding:4px 10px; font-size:13px;">
                    <?php foreach($dimos_list as $dimos): ?>
                        <option value="<?= $dimos['id'] ?>" 
                            <?= ($dimos['id'] == $_SESSION['dimos_id']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($dimos['onoma']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </li>
        </ul>

  </div>
</nav>
<div id="map"></div>
<div id="formContainer" 
     style="display:none; position:absolute; top:20px; left:20px;
     background:white; padding:20px; border-radius:10px;
     z-index:9999; box-shadow:0 0 10px rgba(0,0,0,0.3);">
</div>



<script>
window.loggedUser = {
    
    dimos_id: <?= json_encode($_SESSION['dimos_id']) ?>,
    centroid_lat: <?= json_encode($_SESSION['centroid_lat']) ?>,
    centroid_lng: <?= json_encode($_SESSION['centroid_lng']) ?>,
    zoom: 14
};
</script>

<!-- Sienna Accessibility -->
<script src="https://cdn.jsdelivr.net/npm/sienna-accessibility@latest/dist/sienna-accessibility.umd.js" defer></script>

<script>
document.addEventListener("DOMContentLoaded", () => {
  if (window.SiennaAccessibility) {
    window.SiennaAccessibility.init({
      position: 'bottom-right'
    });
  }
});
</script>

<script src="fieldLabels.js"></script>
<script src="tabFields.js"></script>
<script src="mapInit4.js"></script>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const dimosSelect = document.getElementById('dimosSelect');

    dimosSelect.addEventListener('change', async () => {
        const newDimosId = parseInt(dimosSelect.value);

        try {
            // Φορτώνουμε το νέο centroid
            const res = await fetch(`/va_open/get_dimos_centroid.php?dimos_id=${newDimosId}`);
            const data = await res.json();

            if(data.lat && data.lng){
                // Μετακίνηση χάρτη στο νέο δήμο
                map.setCenter({ lat: data.lat, lng: data.lng });
                map.setZoom(14);

                // Προαιρετικά ενημέρωση session στον server
                await fetch('/va_open/set_session_dimos.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ dimos_id: newDimosId })
                });

                // Ενημέρωση loggedUser για μελλοντική χρήση
                window.loggedUser.dimos_id = newDimosId;
                window.loggedUser.centroid_lat = data.lat;
                window.loggedUser.centroid_lng = data.lng;
            }

        } catch(err){
            console.error('Σφάλμα αλλαγής δήμου:', err);
        }
    });
});
</script>

<script src="geocode.js"></script>
<div id="alertContainer" style="position:absolute; top:10px; left:50%; transform:translateX(-50%); z-index:1000; width:400px;"></div>
<script src="helpers3.js"></script>
<script src="markerInfoWindow_without_lines.js"></script>
<script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBrJuLjZmJIwH8w6ZJRIEPD9OHjTlrTSs0&callback=initMap"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
<script src="https://unpkg.com/tokml/tokml.js"></script>

</body>
</html>