// mapInit4.js
let map;
let geocoder;

// Κατηγορίες & icons
const categories = [
    "Χώροι Στάθμευσης",
    "Διαβάσεις",
    "Ράμπες Πεζοδρομίων",
    "Ράμπες Εισόδου Κτιρίων"
];

const categoryIcons = {
    "Χώροι Στάθμευσης": "icons_map/parking-sign_pin.png",
    "Διαβάσεις": "icons_map/ped_pin2.png",
    "Ράμπες Πεζοδρομίων": "icons_map/ramp_pin3.png",
    "Ράμπες Εισόδου Κτιρίων": "icons_map/ramp_16_pin.png"
};

// Κάνουμε global για Google Maps callback
window.initMap = function() {
    if (!window.loggedUser) {
        console.error('loggedUser is not defined!');
        return;
    }

    const centerLat = loggedUser.centroid_lat;
    const centerLng = loggedUser.centroid_lng;

    map = new google.maps.Map(document.getElementById('map'), {
        center: { lat: centerLat, lng: centerLng },
        zoom: loggedUser.zoom
    });


    geocoder = new google.maps.Geocoder();

    const mapDiv = document.getElementById('map');

    // --- Legend Panel ---
 
    const legendPanel = document.createElement('div');
    legendPanel.id = 'map-legend';
    legendPanel.innerHTML = `
        <div class="legend-header">
            <span>Υπόμνημα Χάρτη</span>
            <button id="legendToggleBtn">–</button>
        </div>
        <div class="legend-body">
            ${categories.map(cat => `
            <label class="legend-item">
                <input type="checkbox" data-category="${cat}" checked>
                <img src="${categoryIcons[cat]}" />
                <span>${cat}</span>
            </label>
            `).join('')}
        </div>
    `;
    document.getElementById('map').appendChild(legendPanel);

    let legendOpen = true;
    document.getElementById('legendToggleBtn').addEventListener('click', () => {
        legendOpen = !legendOpen;
        const legend = document.getElementById('map-legend');
        legend.querySelector('.legend-body').style.display = legendOpen ? 'block' : 'none';
        legend.classList.toggle('closed', !legendOpen);
    });

    const checkboxes = {};
    document.querySelectorAll('#map-legend input[type="checkbox"]').forEach(cb => {
        const cat = cb.dataset.category;
        checkboxes[cat] = cb;
    });





    // --- Markers ανά κατηγορία ---
    const markersByCategory = {};
    categories.forEach(cat => markersByCategory[cat] = []);

    // --- Φόρτωση markers από DB ---
    fetch('/va_open/get_markers_from_db.php')
        .then(res => res.json())
        .then(rows => {
            rows.forEach(data => {
                const lat = parseFloat(data.lat);
                const lng = parseFloat(data.lng);
                if (isNaN(lat) || isNaN(lng)) return;

                const category = data.category;
                const iconUrl = categoryIcons[category];
                if (!iconUrl) return;

                const marker = new google.maps.Marker({
                    position: { lat, lng },
                    map: checkboxes[category].checked ? map : null,
                    icon: { url: iconUrl, scaledSize: new google.maps.Size(36, 36) }
                });

                data.marker = marker;
                markersByCategory[category].push(marker);

                attachInfoWindow(marker, data);
            });

            // Toggle εμφάνισης markers με checkboxes
            categories.forEach(category => {
                checkboxes[category].addEventListener('change', () => {
                    markersByCategory[category].forEach(marker => {
                        marker.setMap(checkboxes[category].checked ? map : null);
                    });
                });
            });
        })
        .catch(err => console.error('Σφάλμα φόρτωσης markers από DB:', err));




    }