<?php
header('Content-Type: application/json');
$data = json_decode(file_get_contents('php://input'), true);

$id = $data['id'] ?? null;
$category_id = $data['category_id'] ?? null;

if (!$id || !$category_id) {
    echo json_encode(['success' => false, 'message' => 'Λείπει το id ή η κατηγορία']);
    exit;
}

// Map category_id to table
$tables = [
    1 => 'parking',
    2 => 'crossings',
    3 => 'pedestrian_ramps',
    4 => 'building_ramps'
];

$table = $tables[$category_id] ?? null;

if (!$table) {
    echo json_encode(['success' => false, 'message' => 'Μη έγκυρη κατηγορία']);
    exit;
}

try {
    $pdo = new PDO('pgsql:host=localhost;port=5433;dbname=postgres','postgres','postgresse!');
    $stmt = $pdo->prepare("DELETE FROM $table WHERE id = :id");
    $stmt->execute([':id' => $id]);
    echo json_encode(['success' => true]);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Σφάλμα βάσης: ' . $e->getMessage()]);
}

