function openFormWithData(data = {}) {
    if (!data) return;

    let container = document.getElementById('formContainer');
    if (!container) {
        container = document.createElement('div');
        container.id = 'formContainer';
        container.style = `
            position:absolute;
            left:20px;
            top:20px;
            z-index:10000;
            background:white;
            padding:10px;
            border:1px solid #ccc;
            border-radius:4px;
            min-width:300px;
            max-width:90vw;
            max-height:80vh;
            box-shadow:0 2px 10px rgba(0,0,0,0.3);
        `;
        document.body.appendChild(container);
    }

    container.style.display = 'block';
    container.innerHTML = '';

    // --- HEADER ---
    const header = document.createElement('div');
    header.id = 'formHeader';
    header.style = 'display:flex; justify-content:space-between; align-items:center; margin-bottom:8px; cursor:move;';
    header.innerHTML = `
        <strong>Επεξεργασία Οντότητας</strong>
        <button class="btn btn-danger btn-xs" id="closeEditForm">✖</button>
    `;
    container.appendChild(header);

    makeDraggable(container, '#formHeader');

    header.querySelector('#closeEditForm').addEventListener('click', () => {
        container.style.display = 'none';
        container.innerHTML = '';
    });

    // --- CATEGORY SELECT ---
    const categorySelect = document.createElement('select');
    categorySelect.className = 'form-control';
    categorySelect.innerHTML = categories.map(c => `<option value="${c}">${c}</option>`).join('');
    categorySelect.value = data.category;
    container.appendChild(categorySelect);

    const isEdit = !!data.id;

    if (isEdit) {
        categorySelect.disabled = true;
        categorySelect.style.background = '#eee';
        categorySelect.style.cursor = 'not-allowed';

        // Προαιρετικό tooltip
        categorySelect.title = 'Η κατηγορία δεν μπορεί να αλλάξει σε επεξεργασία';
    }


    // --- FIELDS CONTAINER ---
    const fieldsDiv = document.createElement('div');
    fieldsDiv.style.marginTop = '10px';
    fieldsDiv.style.maxHeight = '60vh';
    fieldsDiv.style.overflowY = 'auto';
    container.appendChild(fieldsDiv);

    // --- RENDER FIELDS ---
    function render(category) {
        fieldsDiv.innerHTML = getTabFieldsHTML(category);

        setLatLngFields(fieldsDiv, category, data.lat, data.lng);
        populateFields(fieldsDiv, data);

        // --- Custom file inputs for image1 & image2 ---
        ['image1','image2'].forEach(key => {
            const input = fieldsDiv.querySelector(`[name="${key}"]`);
            if (input) {
                input.style.display = 'none';

                const wrapper = document.createElement('div');
                wrapper.className = 'custom-file';
                wrapper.style = `
                    display:flex; 
                    align-items:center; 
                    border:1px solid #ccc; 
                    border-radius:4px; 
                    padding:4px 6px; 
                    margin-bottom:6px;
                    background:#f9f9f9;
                `;

                const button = document.createElement('button');
                button.type = 'button';
                button.textContent = 'Επιλογή αρχείου';
                button.style.marginRight = '6px';
                button.className = 'btn btn-default btn-xs';

                const preview = document.createElement('span');
                preview.style.flex = '1';
                preview.style.fontSize = '12px';
                preview.style.color = '#333';

                // Αν υπάρχει εικόνα στη βάση, εμφάνιση "Προβολή"
                if (data[key]) {
                    const imgUrl = `http://localhost/images/${data[key]}`;
                    preview.innerHTML = `<a href="${imgUrl}" target="_blank">Προβολή</a>`;
                } else {
                    preview.textContent = 'Δεν έχετε επιλέξει αρχείο';
                }

                wrapper.appendChild(button);
                wrapper.appendChild(preview);
                input.parentNode.insertBefore(wrapper, input.nextSibling);

                // Event για να ανοίγει το file picker
                button.addEventListener('click', () => input.click());

                // Event όταν επιλέγεται νέο αρχείο
                input.addEventListener('change', () => {
                    if (input.files && input.files[0]) {
                        preview.textContent = input.files[0].name;
                    } else {
                        preview.textContent = 'Δεν έχετε επιλέξει αρχείο';
                    }
                });
            }
        });

        attachSaveButton(fieldsDiv, container, category, data.lat, data.lng, data);
    }

    render(data.category);

    categorySelect.addEventListener('change', () => {
        data.category = categorySelect.value;
        render(categorySelect.value);
    });
}
